; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "AppTest"
#define MyAppVersion "1.0"
#define MyAppPublisher "rborja.net"
#define MyAppURL "https://rborja.net/"
#define MyAppExeName "AppTestMySQL.exe"
#define AppConfig "AppTestMySQL.exe.config"

[Setup]
; NOTE: The value of AppId uniquely identifies this application. Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{EA060F8A-D768-4DF9-8DA3-F00678BAD2F9}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={autopf}\{#MyAppName}
DisableProgramGroupPage=yes

DisableWelcomePage=no
;ArchitecturesInstallIn64BitMode=x64

; Uncomment the following line to run in non administrative install mode (install for current user only.)
;PrivilegesRequired=lowest
OutputDir=C:\Users\rborj\Desktop
OutputBaseFilename=AppTestSetup
Compression=lzma
SolidCompression=yes
WizardStyle=modern

[Languages]
Name: "spanish"; MessagesFile: "compiler:Languages\Spanish.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

; Se aaden los archivos que se van empaquetar para el instalador
[Files]
Source: "C:\Users\rborj\Desktop\AppTest\AppTestMySQL.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "C:\Users\rborj\Desktop\AppTest\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "C:\Users\rborj\Desktop\Dependencias\MySQL\*"; DestDir: "{tmp}"; Flags: deleteafterinstall
Source: "C:\Users\rborj\Desktop\Dependencias\RTE32\*"; DestDir: "{tmp}"; Flags: deleteafterinstall; Check: not IsWin64
Source: "C:\Users\rborj\Desktop\Dependencias\RTE64\*"; DestDir: "{tmp}"; Flags: deleteafterinstall; Check: IsWin64
Source: "C:\Users\rborj\Desktop\Dependencias\dotNet452\*"; DestDir: "{tmp}"; Flags: deleteafterinstall; Check: not isDot452NetInstalled;
Source: "C:\Users\rborj\Desktop\Dependencias\redis\*"; DestDir: "{tmp}"; Flags: deleteafterinstall; Check: VCRedistNeedsInstall; 


[CODE]

#IFDEF UNICODE
  #DEFINE AW "W"
#ELSE
  #DEFINE AW "A"
#ENDIF
type
  INSTALLSTATE = Longint;
const
  INSTALLSTATE_INVALIDARG = -2;  // An invalid parameter was passed to the function.
  INSTALLSTATE_UNKNOWN = -1;     // The product is neither advertised or installed.
  INSTALLSTATE_ADVERTISED = 1;   // The product is advertised but not installed.
  INSTALLSTATE_ABSENT = 2;       // The product is installed for a different user.
  INSTALLSTATE_DEFAULT = 5;      // The product is installed for the current user.
  VC_2005_REDIST_X86 = '{A49F249F-0C91-497F-86DF-B2585E8E76B7}';
  VC_2005_REDIST_X64 = '{6E8E85E8-CE4B-4FF5-91F7-04999C9FAE6A}';
  VC_2005_REDIST_IA64 = '{03ED71EA-F531-4927-AABD-1C31BCE8E187}';
  VC_2005_SP1_REDIST_X86 = '{7299052B-02A4-4627-81F2-1818DA5D550D}';
  VC_2005_SP1_REDIST_X64 = '{071C9B48-7C32-4621-A0AC-3F809523288F}';
  VC_2005_SP1_REDIST_IA64 = '{0F8FB34E-675E-42ED-850B-29D98C2ECE08}';
  VC_2005_SP1_ATL_SEC_UPD_REDIST_X86 = '{837B34E3-7C30-493C-8F6A-2B0F04E2912C}';
  VC_2005_SP1_ATL_SEC_UPD_REDIST_X64 = '{6CE5BAE9-D3CA-4B99-891A-1DC6C118A5FC}';
  VC_2005_SP1_ATL_SEC_UPD_REDIST_IA64 = '{85025851-A784-46D8-950D-05CB3CA43A13}';
  VC_2008_REDIST_X86 = '{FF66E9F6-83E7-3A3E-AF14-8DE9A809A6A4}';
  VC_2008_REDIST_X64 = '{350AA351-21FA-3270-8B7A-835434E766AD}';
  VC_2008_REDIST_IA64 = '{2B547B43-DB50-3139-9EBE-37D419E0F5FA}';
  VC_2008_SP1_REDIST_X86 = '{9A25302D-30C0-39D9-BD6F-21E6EC160475}';
  VC_2008_SP1_REDIST_X64 = '{8220EEFE-38CD-377E-8595-13398D740ACE}';
  VC_2008_SP1_REDIST_IA64 = '{5827ECE1-AEB0-328E-B813-6FC68622C1F9}';
  VC_2008_SP1_ATL_SEC_UPD_REDIST_X86 = '{1F1C2DFC-2D24-3E06-BCB8-725134ADF989}';
  VC_2008_SP1_ATL_SEC_UPD_REDIST_X64 = '{4B6C7001-C7D6-3710-913E-5BC23FCE91E6}';
  VC_2008_SP1_ATL_SEC_UPD_REDIST_IA64 = '{977AD349-C2A8-39DD-9273-285C08987C7B}';
  VC_2008_SP1_MFC_SEC_UPD_REDIST_X86 = '{9BE518E6-ECC6-35A9-88E4-87755C07200F}';
  VC_2008_SP1_MFC_SEC_UPD_REDIST_X64 = '{5FCE6D76-F5DC-37AB-B2B8-22AB8CEDB1D4}';
  VC_2008_SP1_MFC_SEC_UPD_REDIST_IA64 = '{515643D1-4E9E-342F-A75A-D1F16448DC04}';
  VC_2010_REDIST_X86 = '{196BB40D-1578-3D01-B289-BEFC77A11A1E}';
  VC_2010_REDIST_X64 = '{DA5E371C-6333-3D8A-93A4-6FD5B20BCC6E}';
  VC_2010_REDIST_IA64 = '{C1A35166-4301-38E9-BA67-02823AD72A1B}';
  VC_2010_SP1_REDIST_X86 = '{F0C3E5D1-1ADE-321E-8167-68EF0DE699A5}';
  VC_2010_SP1_REDIST_X64 = '{1D8E6291-B0D5-35EC-8441-6616F567A0F7}';
  VC_2010_SP1_REDIST_IA64 = '{88C73C1C-2DE5-3B01-AFB8-B46EF4AB41CD}';
  // Microsoft Visual C++ 2012 x86 Minimum Runtime - 11.0.61030.0 (Update 4) 
  VC_2012_REDIST_MIN_UPD4_X86 = '{BD95A8CD-1D9F-35AD-981A-3E7925026EBB}';
  VC_2012_REDIST_MIN_UPD4_X64 = '{CF2BEA3C-26EA-32F8-AA9B-331F7E34BA97}';
  // Microsoft Visual C++ 2012 x86 Additional Runtime - 11.0.61030.0 (Update 4) 
  VC_2012_REDIST_ADD_UPD4_X86 = '{B175520C-86A2-35A7-8619-86DC379688B9}';
  VC_2012_REDIST_ADD_UPD4_X64 = '{37B8F9C7-03FB-3253-8781-2517C99D7C00}';
  // Visual C++ 2013 Redistributable 12.0.21005
  VC_2013_REDIST_X86_MIN = '{13A4EE12-23EA-3371-91EE-EFB36DDFFF3E}';
  VC_2013_REDIST_X64_MIN = '{A749D8E6-B613-3BE3-8F5F-045C84EBA29B}';
  VC_2013_REDIST_X86_ADD = '{F8CFEB22-A2E7-3971-9EDA-4B11EDEFC185}';
  VC_2013_REDIST_X64_ADD = '{929FBD26-9020-399B-9A7A-751D61F0B942}';
  // Visual C++ 2015 Redistributable 14.0.23026
  VC_2015_REDIST_X86_MIN = '{A2563E55-3BEC-3828-8D67-E5E8B9E8B675}';
  VC_2015_REDIST_X64_MIN = '{0D3E9E15-DE7A-300B-96F1-B4AF12B96488}';
  VC_2015_REDIST_X86_ADD = '{BE960C1C-7BAD-3DE6-8B1A-2616FE532845}';
  VC_2015_REDIST_X64_ADD = '{BC958BD2-5DAC-3862-BB1A-C1BE0790438D}';
  // Visual C++ 2019 Redistributable 14.25.28508
  VC_2019_REDIST_X86_MIN = '{2BC3BD4D-FABA-4394-93C7-9AC82A263FE2}';
  VC_2019_REDIST_X64_MIN = '{EEA66967-97E2-4561-A999-5C22E3CDE428}';
  VC_2019_REDIST_X86_ADD = '{0FA68574-690B-4B00-89AA-B28946231449}';
  VC_2019_REDIST_X64_ADD = '{7D0B74C2-C3F8-4AF1-940F-CD79AB4B2DCE}';
  // Visual C++ 2019 Redistributable 14.27.29112
  VC_2019_2_REDIST_X86_MIN = '{42163859-095F-469B-A0B0-7748500570D1}';
  VC_2019_2_REDIST_X64_MIN = '{37BB1766-C587-49AE-B2DB-618FBDEAB88C}';
  VC_2019_2_REDIST_X86_ADD = '{526B224D-6B70-4A2A-9D03-CE304B5125D6}';
  VC_2019_2_REDIST_X64_ADD = '{1B4EDD59-90CE-4BDE-8520-630981088165}';
  //Estos cdigos vienen de aqui en regedit cuando estan instalados estos productos HKEY_CLASSES_ROOT\Installer\Dependencies\Microsoft.VS.VC_RuntimeAdditionalVSU_amd64,v14
  
  function MsiQueryProductState(szProduct: string): INSTALLSTATE; 
  external 'MsiQueryProductState{#AW}@msi.dll stdcall';
function VCVersionInstalled(const ProductID: string): Boolean;
begin
  Result := MsiQueryProductState(ProductID) = INSTALLSTATE_DEFAULT;
end;
function VCRedistNeedsInstall: Boolean;
begin
  Result := not (VCVersionInstalled(VC_2019_2_REDIST_X86_MIN));
end;

var

lblPort: TLabel;
lblServiceName: TLabel;
ePort: TEdit;
eServiceName: TEdit;

procedure frmDBSettingsReg_Activate(Page: TWizardPage);
begin
end;

function frmDBSettingsReg_ShouldSkipPage(Page: TWizardPage): Boolean;
begin
Result := False;
end;

function frmDBSettingsReg_BackButtonClick(Page: TWizardPage): Boolean;
begin
Result := True;
end;

function frmDBSettingsReg_NextButtonClick(Page: TWizardPage): Boolean;
begin
Result := True;
end;

procedure frmDBSettingsReg_CancelButtonClick(Page: TWizardPage; var Cancel, Confirm: Boolean);
begin
end;

function frmDBSettingsReg_CreatePage(PreviousPageId: Integer): Integer;

var
Page: TWizardPage;
begin
Page := CreateCustomPage(
PreviousPageId,
'Prametros de instalacin de  MySQL',
'Seleccione el nombre del servicio y el puerto');


{ lblPort }
lblPort := TLabel.Create(Page);
with lblPort do
begin
Parent := Page.Surface;
Left := ScaleX(24);
Top := ScaleY(30);
Width := ScaleX(35);
Height := ScaleY(13);
Caption := ExpandConstant('Puerto:');
end;

{ lblServiceName }
lblServiceName := TLabel.Create(Page);
with lblServiceName do
begin
Parent := Page.Surface;
Left := ScaleX(24);
Top := ScaleY(60);
Width := ScaleX(52);
Height := ScaleY(13);
Caption := ExpandConstant('Servicio') ;
end;


{ ePort }
ePort := TEdit.Create(Page);
with ePort do
begin
Parent := Page.Surface;
Left := ScaleX(130);
Top := ScaleY(27);
Width := ScaleX(185);
Height := ScaleY(21);
Text := '3306';
TabOrder := 0;
end;

{ eServiceName }
eServiceName := TEdit.Create(Page);
with eServiceName do
begin
Parent := Page.Surface;
Left := ScaleX(130);
Top := ScaleY(56);
Width := ScaleX(185);
Height := ScaleY(21);
Text := 'MySQL';
TabOrder := 1;
end;



with Page do
begin
OnActivate := @frmDBSettingsReg_Activate;
//OnShouldSkipPage := @frmDBSettingsReg_ShouldSkipPage;
OnBackButtonClick := @frmDBSettingsReg_BackButtonClick;
OnNextButtonClick := @frmDBSettingsReg_NextButtonClick;
OnCancelButtonClick := @frmDBSettingsReg_CancelButtonClick;
end;

Result := Page.ID;
end;

function GetPort(param: String): String;
begin
  Result := Trim(ePort.Text);
end;
function GetServiceName(param: String): String;
begin
  Result := Trim(eServiceName.Text);
end;


{Reemplaza el puerto 3306 por el que se definio en el campo de texto del instalador}
function ReplaceValue(const FileName, Port: string): Boolean;
var
  UnicodeStr: string;
  ANSIStr: AnsiString;
begin

    if LoadStringFromFile(Filename, ANSIStr) then
       UnicodeStr := String(ANSIStr);
    if StringChangeEx(UnicodeStr, '3306', Port, True) > 0 then
      SaveStringToFile(filename, AnsiString(UnicodeStr), False);

    Result := True;
end;

function isDot452NetInstalled: Boolean;
begin
  Result := IsDotNetInstalled(net452, 0); //Returns True if .NET Framework version 4.6.2 is installed, or a compatible version such as 4.8
end;

{ Evento que se ejecuta cada que se cambia de paso}
procedure CurStepChanged(CurStep: TSetupStep);
begin
  if CurStep = ssPostInstall then {Si no encontramos en la post instalacin ejecutar la siguiente funcin}
  begin
    ReplaceValue(ExpandConstant('{app}') + '\' + ExpandConstant('{#AppConfig}'),Trim(ePort.Text)); {Reemplaza el puerto default 3306 de MySQL por el que se seleccion en el instalador}
  end;
end;procedure InitializeWizard;
begin
  {Mostrar la pgina personalizada de configuracin de MySQL despes de la pgina de bienvenida}
  frmDBSettingsReg_CreatePage(wpWelcome);
end;


[Icons]
Name: "{autoprograms}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"
Name: "{autodesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon

[Run]

;Instalar .NET Framework 4.5.2 si no tiene este o una versin superior
Filename: "{tmp}\NDP452-KB2901907-x86-x64-AllOS-ENU.exe";  StatusMsg: Instalando .NET Framework 4.5.2; Check: not isDot452NetInstalled;

;Instalar dependecia de MySQL si no esta instalada
Filename: "{tmp}\VC_redist.x86.exe"; Parameters: "/q /norestart /q:a /c:""VCREDI~3.EXE /q:a /c:""""msiexec /i vcredist.msi /qn"""" """; Check: VCRedistNeedsInstall; WorkingDir: {tmp}; StatusMsg: Instalando VC++ 2019 x86 Redistributable

;Instalar MySQL
;Filename: msiexec.exe;  Parameters : " /i {tmp}\mariadb-10.5.7-win32.msi SERVICENAME={code:GetServiceName} PORT={code:GetPort} ALLOWREMOTEROOTACCESS=1 PASSWORD=12345678 ADDLOCAL=ALL REMOVE=HeidiSQL /qn"; WorkingDir:{tmp}; StatusMsg: Instalando MySQL; Flags: runhidden;  
Filename: msiexec.exe;  Parameters : " /i {tmp}\mariadb-10.4.16-win32.msi SERVICENAME={code:GetServiceName} PORT={code:GetPort} ALLOWREMOTEROOTACCESS=1 PASSWORD=12345678 ADDLOCAL=ALL REMOVE=HeidiSQL /qn"; WorkingDir:{tmp}; StatusMsg: Instalando MySQL; Flags: runhidden;  


;Abre el puerto de MySQL en el firewall
Filename: netsh; Parameters: firewall add portopening TCP {code:GetPort} {code:GetServiceName};  Flags: runhidden; StatusMsg: Habilitando puertos en el firewall

;Se ejecuta el script de base de datos que crea la base de datos y el usuario de base de datos.
Filename: "{tmp}\db_script.bat"; Parameters:" ""{commonpf32}\MariaDB 10.4\bin"" ""{code:GetPort}"" ""{tmp}\rborjanet.sql"""; StatusMsg: Creando base de datos; Flags: runhidden;

;Instalando los drivers para el sensor de huellas digitales de digital persona
Filename: "{tmp}\setup.exe"; StatusMsg: Instalando drivers de DigitalPersona

;Abre la aplicacin si se selecciona que se ejecutara despues de terminar la instalacin
Filename: "{app}\{#MyAppExeName}"; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}"; Flags: nowait postinstall skipifsilent
